<?php
    use \Milon\Barcode\DNS1D;
    $d = new DNS1D();
    $user_role = auth()->user()->role;
    $admin  = 1;
    $code = filter_var($shipment->code, FILTER_SANITIZE_NUMBER_INT);
?>



<?php $__env->startSection('pageTitle'); ?>
    <?php echo e(__('cargo::view.package_list')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!--begin::Entry-->
<div class="d-flex flex-column-fluid">
    <!--begin::Container-->
    <div class="container">
        <!-- begin::Card-->
        <div class="overflow-hidden card card-custom">
            <div class="p-0 card-body">
                <!-- begin: Invoice-->
                <!-- begin: Invoice header-->
                <div class="px-8 py-8 row justify-content-center py-md-27 px-md-0">
                    <div class="col-md-9">
                        <div class="pb-10 d-flex justify-content-between pb-md-20 flex-column flex-md-row">
                            <h1 class="mb-10 display-4 font-weight-boldest">
                                <?php 
                                    $system_logo = App\Models\Settings::where('group', 'general')->where('name','system_logo')->first();
                                ?>
                                <img alt="Logo" src="<?php echo e($system_logo->getFirstMediaUrl('system_logo') ? $system_logo->getFirstMediaUrl('system_logo') : asset('assets/lte/cargo-logo.svg')); ?>" class="logo" style="max-height: 90px;" />
                                <?php echo e(__('cargo::view.INVOICE')); ?>

                            </h1>
                            <div class="px-0 d-flex flex-column align-items-md-end">
                                <!--begin::Logo-->
                                <a href="#">
                                    <?php if($shipment->barcode != null): ?>
                                        <?php
                                            echo '<img src="data:image/png;base64,' . $d->getBarcodePNG($shipment->code, "C128") . '" alt="barcode"   />';
                                        ?>
                                    <?php endif; ?>
                                </a>
                                <!--end::Logo-->
                                <span class="d-flex flex-column align-items-md-end opacity-70">
                                    <br />
                                    <span><span class="font-weight-bolder"><?php echo e(__('cargo::view.from')); ?>:</span> <?php echo e($shipment->from_address->address); ?></span>
                                    <span><span class="font-weight-bolder"><?php echo e(__('cargo::view.to')); ?>:</span> <?php echo e($shipment->reciver_address); ?></span>
                                </span>
                            </div>
                        </div>
                        <div class="border-bottom w-100"></div>
                        <div class="pt-6 d-flex justify-content-between">
                            <div class="d-flex flex-column flex-root">
                                <span class="mb-2 font-weight-bolder d-block"><?php echo e(__('cargo::view.DATE')); ?><span>
                                <span class="opacity-70 d-block"><?php echo e($shipment->created_at->format('Y-m-d')); ?></span>
                            </div>
                            <div class="d-flex flex-column flex-root">
                                <span class="mb-2 font-weight-bolder"><?php echo e(__('cargo::view.SHIPMENT_CODE')); ?></span>
                                <span class="opacity-70"><?php echo e($shipment->code); ?></span>
                            </div>
                            <div class="d-flex flex-column flex-root">
                                <span class="mb-2 font-weight-bolder"><?php echo e(__('cargo::view.INVOICE_TO')); ?></span>
                                <span class="opacity-70"><?php echo e($shipment->reciver_address); ?>.
                                <br /><?php echo e($shipment->reciver_name); ?>.
                                <br /><?php echo e($shipment->reciver_phone); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end: Invoice header-->
                <!-- begin: Invoice body-->
                <div class="px-8 py-8 row justify-content-center py-md-10 px-md-0">
                    <div class="col-md-9">
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th class="pl-0 font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.package_items')); ?></th>
                                        <th class="text-right font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.qty')); ?></th>
                                        <th class="text-right font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.type')); ?></th>
                                        <th class="pr-0 text-right font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.Weight_length_width_height_')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php $__currentLoopData = Modules\Cargo\Entities\PackageShipment::where('shipment_id',$shipment->id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <tr class="font-weight-boldest">
                                            <td class="pl-0 border-0 pt-7 d-flex align-items-center"><?php echo e($package->description); ?></td>
                                            <td class="text-right align-middle pt-7"><?php echo e($package->qty); ?></td>
                                            <td class="text-right align-middle pt-7"><?php if(isset($package->package->name)): ?><?php echo e(json_decode($package->package->name, true)[app()->getLocale()]); ?> <?php else: ?> - <?php endif; ?></td>
                                            <td class="pr-0 text-right align-middle text-primary pt-7"><?php echo e($package->weight." ".__('cargo::view.KG')." x ".$package->length." ".__('cargo::view.CM')." x ".$package->width." ".__('cargo::view.CM')." x ".$package->height." ".__('cargo::view.CM')); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- end: Invoice body-->
                <!-- begin: Invoice footer-->
                <div class="px-8 py-8 bg-gray-100 row justify-content-center py-md-10 px-md-0">
                    <div class="col-md-9">
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th class="font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.PAYMENT_TYPE')); ?></th>
                                        <th class="font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.PAYMENT_STATUS')); ?></th>
                                        <th class="font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.PAYMENT_DATE')); ?></th>
                                        <th class="text-right font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.TOTAL_COST')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr class="font-weight-bolder">
                                        <td><?php echo e($shipment->payment_method_id); ?> (<?php echo e($shipment->getPaymentType()); ?>)</td>
                                        <td><?php if($shipment->paid == 1): ?> <?php echo e(__('cargo::view.paid')); ?> <?php else: ?> <?php echo e(__('cargo::view.pending')); ?> <?php endif; ?></td>
                                        <td><?php if($shipment->paid == 1): ?> <?php echo e($shipment->payment->payment_date ?? ""); ?> <?php else: ?> - <?php endif; ?></td>
                                        <td class="text-right text-primary font-size-h3 font-weight-boldest"><?php echo e(format_price($shipment->tax + $shipment->shipping_cost + $shipment->insurance)); ?><br /><span class="text-muted font-weight-bolder font-size-lg"><?php echo e(__('cargo::view.included_tax_insurance')); ?></span></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- end: Invoice footer-->
                <!-- begin: Invoice action-->
                <div class="px-8 py-8 row justify-content-center py-md-10 px-md-0 no-print">
                    <div class="col-md-9">
                        <div class="d-flex justify-content-between">
                            <button type="button" class="btn btn-primary font-weight-bold" onclick="window.print();"><?php echo e(__('cargo::view.print_invoice')); ?></button>
                        </div>
                    </div>
                </div>
                <!-- end: Invoice action-->
                <!-- end: Invoice-->
            </div>
        </div>
        <!-- end::Card-->
    </div>
    <!--end::Container-->
</div>
<!--end::Entry-->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('styles'); ?>
<style media="print">
    .no-print, div#kt_header_mobile, div#kt_header, div#kt_footer{
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script>
    window.onload = function() {
        setTimeout(function () {
            javascript:window.print();
        }, 300);
    };
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('cargo::adminLte.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedes/courier.elitedesign.com.bd/Modules/Cargo/Resources/views/adminLte/pages/shipments/print-invoice.blade.php ENDPATH**/ ?>