<?php echo csrf_field(); ?>

<div class="card-body">
    <div class="row">
        <div class="col-lg-12">
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label><?php echo e(__('cargo::view.beneficiary')); ?>:</label>
                        <select class="form-control mb-5 kt-select2 select-beneficiary" name="type" onchange="enable_select(this)">
                            <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>"><?php echo e($type['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </select>
                    </div>
                </div>
                <div class="col-md-6" id="captain" <?php if(auth()->user()->role == 3 || auth()->user()->role == 0): ?> style="display: block" <?php else: ?> style="display: none" <?php endif; ?>>
                    <div class="form-group">
                        <label><?php echo e(__('cargo::view.driver')); ?>:</label>
                        <select class="form-control mb-5 kt-select2 select-captain" name="captain">
                            <option></option>
                            <?php $__currentLoopData = $captains; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $captain): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($captain->id); ?>"><?php echo e($captain->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </select>
                    </div>
                </div>
                <div class="col-md-6" id="client" style="display: none">
                    <div class="form-group">
                        <label><?php echo e(__('cargo::view.client')); ?>:</label>
                        <select class="form-control mb-5 kt-select2 select-client" name="client">
                            <option></option>
                            <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($client->id); ?>"><?php echo e($client->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </select>
                    </div>
                </div>

                <div class="col-md-6" id="branch" <?php if(auth()->user()->role == 3 || auth()->user()->role == 0): ?> style="display: none" <?php else: ?> style="display: block" <?php endif; ?>>
                    <div class="form-group">
                        <label><?php echo e(__('cargo::view.table.branch')); ?>:</label>
                        <select class="form-control mb-5 kt-select2 select-branch" name="branch">
                            <option></option>
                            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($branch->id); ?>"><?php echo e($branch->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </select>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label><?php echo e(__('cargo::view.wallet_type')); ?>:</label>
                        <select class="form-control mb-5 kt-select2" name="wallet_type">
                            <option value="add"><?php echo e(__('cargo::view.add_to_wallet')); ?></option>
                            <option value="deduct"><?php echo e(__('cargo::view.deduct_from_wallet')); ?></option>
                        </select>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label><?php echo e(__('cargo::view.amount')); ?>:</label>
                        <input id="kt_touchspin_4" placeholder="<?php echo e(__('cargo::view.amount')); ?>" type="text" class="form-control mb-5 total-weight" value="0" name="amount" />
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="form-group">
                        <label><?php echo e(__('cargo::view.description')); ?>:</label>
                        <textarea name="description" id="description" class="form-control mb-5" cols="30" rows="3" placeholder="<?php echo e(__('cargo::view.description')); ?>"></textarea>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php $__env->startSection('styles'); ?>
    <style>
        label {
            font-weight: bold !important;
        }
    </style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-touchspin/4.3.0/jquery.bootstrap-touchspin.min.js" integrity="sha512-0hFHNPMD0WpvGGNbOaTXP0pTO9NkUeVSqW5uFG2f5F9nKyDuHE3T4xnfKhAhnAZWZIO/gBLacwVvxxq0HuZNqw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-touchspin/4.3.0/jquery.bootstrap-touchspin.js" integrity="sha512-k59zBVzm+v8h8BmbntzgQeJbRVBK6AL1doDblD1pSZ50rwUwQmC/qMLZ92/8PcbHWpWYeFaf9hCICWXaiMYVRg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script type="text/javascript">
        $('#kt_touchspin_4').TouchSpin({
            buttondown_class: 'btn btn-secondary',
            buttonup_class: 'btn btn-secondary',

            min: 1,
            max: 1000000000,
            stepinterval: 50,
            maxboostedstep: 10000000,
            initval: 1,
        });
        var types = <?php echo json_encode($types, 15, 512) ?>;
        function enable_select(select_type) {
            for (const [key, value] of Object.entries(types)) {
                document.getElementById(types[key]['key']).style.display = "none";
            }
            document.getElementById(types[select_type.value]['key']).style.display = "block";
        }
    </script>
<?php $__env->stopSection(); ?><?php /**PATH /home/elitedesignbd/courier.elitedesign.com.bd/Modules/Cargo/Resources/views/adminLte/pages/transactions/form.blade.php ENDPATH**/ ?>