<?php
    use \Milon\Barcode\DNS1D;
    $d = new DNS1D();
    $user_role = auth()->user()->role;
    $admin  = 1;

?>



<?php $__env->startSection('pageTitle'); ?>
    <?php echo e(__('cargo::view.shipment').'-'. $shipment->code); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <!--begin::Card-->
    <div class="card card-custom gutter-b">
        <div class="p-0 card-body">
            <!-- begin: Invoice-->
            <!-- begin: Invoice header-->
            <div class="px-8 py-8 row justify-content-center pt-md-27 px-md-0">
                <div class="col-md-10">
                    <div class="pb-10 d-flex justify-content-between pb-md-20 flex-column flex-md-row">
                        <div class="px-0 d-flex flex-column align-items-md-start">
                            <span class="d-flex flex-column align-items-md-start">
                                <h1 class="mb-10 display-4 font-weight-boldest"><?php echo e(__('cargo::view.shipment')); ?>: <?php echo e($shipment->code); ?></h1>
                                <?php if($shipment->order_id != null): ?>
                                    <span><span class="font-weight-bolder opacity-70"><?php echo e(__('cargo::view.order_id')); ?>:</span> <?php echo e($shipment->order_id); ?></span>
                                <?php endif; ?>
                            </span>
                        </div>
                        <div class="px-0 d-flex flex-column align-items-md-end">
                            <span class="d-flex flex-column align-items-md-end opacity-70">
                                <?php if($shipment->barcode != null): ?>
                                    <span class="mb-5 font-weight-bolder"><?=$d->getBarcodeHTML($shipment->code, "C128");?></span>
                                <?php endif; ?>
                                <span><span class="font-weight-bolder"><?php echo e(__('cargo::view.from')); ?>:</span> <?php echo e($shipment->from_address ? $shipment->from_address->address : ''); ?></span>
                                <span><span class="font-weight-bolder"><?php echo e(__('cargo::view.to')); ?>:</span> <?php echo e($shipment->reciver_address); ?></span>
                            </span>
                        </div>
                    </div>

                    <div class="pb-6 d-flex justify-content-between">
                        <div class="d-flex flex-column flex-root">
                            <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.client_sender')); ?></span>
                            <?php if($user_role == $admin || auth()->user()->can('show-clients') ): ?>
                                <a class="text-danger font-weight-boldest font-size-lg" href="<?php echo e(route('clients.show',$shipment->client_id)); ?>"><?php echo e($shipment->client->name); ?></a>
                            <?php else: ?>
                                <span class="text-danger font-weight-boldest font-size-lg"><?php echo e($shipment->client->name); ?></span>
                            <?php endif; ?>
                            <span class="text-muted font-size-md"><?php echo e($shipment->client_phone); ?></span>
                            <span class="text-muted font-size-md"><?php echo e($shipment->from_address ? $shipment->from_address->address : ''); ?></span>
                        </div>
                        <div class="d-flex flex-column flex-root">
                            <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.receiver')); ?></span>
                            <span class="text-danger font-weight-boldest font-size-lg"><?php echo e($shipment->reciver_name); ?></span>
                            <span class="text-muted font-size-md"><?php echo e($shipment->reciver_phone); ?></span>
                            <span class="text-muted font-size-md"><?php echo e($shipment->reciver_address); ?></span>
                        </div>
                        <div class="d-flex flex-column flex-root">
                            <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.status')); ?></span>
                            <span class="opacity-70 d-block"><?php echo e($shipment->getStatus()); ?></span>
                        </div>

                        <?php if(isset($shipment->amount_to_be_collected)): ?>
                            <div class="d-flex flex-column flex-root">
                                <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.amount_to_be_collected')); ?></span>
                                <span class="text-muted font-weight-bolder font-size-lg"><?php echo e(format_price($shipment->amount_to_be_collected)); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="border-bottom w-100"></div>
                    <div class="pt-6 d-flex justify-content-between">
                        <div class="d-flex flex-column flex-root">
                            <span class="mb-2 font-weight-bolder"><?php echo e(__('cargo::view.shipment_type')); ?></span>
                            <span class="opacity-70"><?php echo e($shipment->type); ?></span>
                        </div>
                        <div class="d-flex flex-column flex-root">
                            <span class="mb-2 font-weight-bolder"><?php echo e(__('cargo::view.current_branch')); ?></span>
                            <?php if($user_role == $admin || auth()->user()->can('show-branches') ): ?>
                                <a class="opacity-70" href="<?php echo e(route('branches.show',$shipment->branch_id)); ?>"><?php echo e($shipment->branch->name); ?></a>
                            <?php else: ?>
                                <span class="text-danger font-weight-boldest font-size-lg"><?php echo e($shipment->branch->name); ?></span>
                            <?php endif; ?>
                        </div>
                        <div class="d-flex flex-column flex-root">
                            <span class="mb-2 font-weight-bolder"><?php echo e(__('cargo::view.created_date')); ?></span>
                            <span class="opacity-70"><?php echo e($shipment->created_at->format('d-m-Y h:i:s')); ?></span>
                        </div>
                        <div class="d-flex flex-column flex-root">
                            <span class="mb-2 font-weight-bolder"><?php echo e(__('cargo::view.shipping_date')); ?></span>
                            <span class="opacity-70">
                                <?php if(strpos($shipment->shipping_date, '/' )): ?>
                                    <?php echo e(Carbon\Carbon::createFromFormat('d/m/Y', $shipment->shipping_date)->format('d-m-Y')); ?>

                                <?php else: ?>
                                     <?php echo e(\Carbon\Carbon::parse($shipment->shipping_date)->format('d-m-Y')); ?>

                                <?php endif; ?>
                                 </span>
                        </div>
                    </div>


                    <div class="pt-6 d-flex justify-content-between">
                        <?php if($shipment->prev_branch): ?>
                            <div class="d-flex flex-column flex-root">
                                <span class="mb-2 font-weight-bolder"><?php echo e(__('cargo::view.previous_branch')); ?></span>
                                <span class="opacity-70"><?php echo e(Modules\Cargo\Entities\Branch::find($shipment->prev_branch)->name); ?></span>
                            </div>
                        <?php endif; ?>
                        <div class="d-flex flex-column flex-root">
                            <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.total_weight')); ?></span>
                            <span class="text-muted font-weight-bolder font-size-lg"><?php echo e($shipment->total_weight); ?> <?php echo e(__('cargo::view.KG')); ?></span>
                        </div>
                        <div class="d-flex flex-column flex-root">
                            <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.shipping_cost')); ?></span>
                            <span class="text-muted font-weight-bolder font-size-lg"><?php echo e(format_price($shipment->shipping_cost)); ?></span>
                        </div>
                        <div class="d-flex flex-column flex-root">
                            <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.tax_duty')); ?></span>
                            <span class="text-muted font-weight-bolder font-size-lg"><?php echo e(format_price($shipment->tax)); ?></span>
                        </div>
                        <div class="d-flex flex-column flex-root">
                            <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.insurance')); ?></span>
                            <span class="text-muted font-weight-bolder font-size-lg"><?php echo e(format_price($shipment->insurance)); ?></span>
                        </div>
                        <div class="d-flex flex-column flex-root">
                            <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.return_cost')); ?></span>
                            <span class="text-muted font-weight-bolder font-size-lg"><?php echo e(format_price($shipment->return_cost)); ?></span>
                        </div>
                    </div>

                    <div class="pt-6 d-flex justify-content-between">
                        <div class="d-flex flex-column flex-root">
                                <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.from_country')); ?></span>
                                <span class="text-muted font-weight-bolder font-size-lg"><?php if(isset($shipment->from_country)): ?><?php echo e($shipment->from_country->name); ?> <?php endif; ?> </span>
                        </div>
                        <div class="d-flex flex-column flex-root">
                                <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.to_country')); ?></span>
                                <span class="text-muted font-weight-bolder font-size-lg"><?php if(isset($shipment->to_country)): ?><?php echo e($shipment->to_country->name); ?> <?php endif; ?> </span>
                        </div>
                        <div class="d-flex flex-column flex-root">
                                <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.from_region')); ?></span>
                                <span class="text-muted font-weight-bolder font-size-lg"><?php if(isset($shipment->from_state)): ?><?php echo e($shipment->from_state->name); ?> <?php endif; ?> </span>
                        </div>
                        <div class="d-flex flex-column flex-root">
                                <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.to_region')); ?></span>
                                <span class="text-muted font-weight-bolder font-size-lg"><?php if(isset($shipment->to_state)): ?><?php echo e($shipment->to_state->name); ?> <?php endif; ?> </span>
                        </div>

                        <?php if(isset($shipment->from_area)): ?>
                            <div class="d-flex flex-column flex-root">
                                <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.from_area')); ?></span>
                                <span class="text-muted font-weight-bolder font-size-lg"><?php echo e(json_decode($shipment->from_area->name, true)[app()->getLocale()]); ?></span>
                            </div>
                        <?php endif; ?>

                        <?php if(isset($shipment->to_area)): ?>
                            <div class="d-flex flex-column flex-root">
                                    <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.to_area')); ?></span>
                                    <span class="text-muted font-weight-bolder font-size-lg"><?php echo e(json_decode($shipment->to_area->name, true)[app()->getLocale()]); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>


                    <div class="pt-6 d-flex justify-content-between">
                        <div class="d-flex flex-column flex-root">
                            <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.max_delivery_days')); ?></span>
                            <span class="text-muted font-weight-bolder font-size-lg"><?php echo e($shipment->deliveryTime ? json_decode($shipment->deliveryTime->name, true)[app()->getLocale()] : ''); ?></span>
                        </div>
                        <?php if($shipment->collection_time != null): ?>
                            <div class="d-flex flex-column flex-root">
                                <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.collection_time')); ?></span>
                                <span class="text-muted font-weight-bolder font-size-lg"><?php echo e($shipment->collection_time); ?></span>
                            </div>
                        <?php endif; ?>
                        <?php if($shipment->captain_id != null): ?>
                            <div class="d-flex flex-column flex-root">
                                <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.driver')); ?></span>
                                <?php if($user_role == $admin || auth()->user()->can('show-drivers')): ?>
                                    <a class="text-danger font-weight-boldest font-size-lg" href="<?php echo e(route('drivers.show',$shipment->captain_id)); ?>"><?php echo e($shipment->captain->name); ?> </a>
                                <?php else: ?>
                                    <span class="text-muted font-weight-boldest font-size-lg"><?php echo e($shipment->captain->name); ?></span>
                                <?php endif; ?>

                            </div>
                        <?php endif; ?>
                        <?php if($shipment->current_mission != null): ?>
                            <div class="d-flex flex-column flex-root">
                                <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.mission')); ?></span>
                                <?php if($user_role == $admin || auth()->user()->can('show-missions')): ?>
                                    <a class="text-danger font-weight-bolder font-size-lg" href="<?php echo e(route('missions.show',$shipment->current_mission)); ?>"><?php echo e($shipment->current_mission->code); ?></a>
                                <?php else: ?>
                                    <span class="text-muted font-weight-bolder font-size-lg"><?php echo e($shipment->current_mission->code); ?></span>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php if(count($shipment->getMedia('attachments')) > 0): ?>
                        <div class="pt-6 d-flex justify-content-between">
                            <div class="d-flex flex-column flex-root">
                                <span class="mb-4 text-dark font-weight-bold"><?php echo e(__('cargo::view.attachments')); ?> <span class="text-muted font-size-xs">(<?php echo e(__('cargo::view.ADDED_WHEN_SHIPMENT_CREATED')); ?> )</span></span>
                                <div class="pt-6 d-flex justify-content-between">
                                    <?php $__currentLoopData = $shipment->getMedia('attachments'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="d-flex flex-column flex-root ml-1">
                                            <span class="text-muted font-weight-bolder font-size-lg">
                                                <a href="<?php echo e($img->getUrl()); ?>" target="_blank"><img src="<?php echo e($img->getUrl()); ?>" alt="image" style="max-width:100px;max-height:60px" /></a>
                                            </span>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>


                </div>
            </div>
            <!-- end: Invoice header-->
            <!-- begin: Invoice body-->
            <div class="px-8 py-8 row justify-content-center py-md-10 px-md-0">
                <div class="col-md-10">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th class="pl-0 font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.package_items')); ?></th>
                                    <th class="text-right font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.qty')); ?></th>
                                    <th class="text-right font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.type')); ?></th>
                                    <th class="pr-0 text-right font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.weigh_length_width_height')); ?></th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php $__currentLoopData = Modules\Cargo\Entities\PackageShipment::where('shipment_id',$shipment->id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <tr class="font-weight-boldest">
                                        <td class="pl-0 border-0 pt-7 d-flex align-items-center"><?php echo e($package->description); ?></td>
                                        <td class="text-right align-middle pt-7"><?php echo e($package->qty); ?></td>
                                        <td class="text-right align-middle pt-7"><?php if(isset($package->package->name)): ?><?php echo e(json_decode($package->package->name, true)[app()->getLocale()]); ?> <?php else: ?> - <?php endif; ?></td>
                                        <td class="pr-0 text-right align-middle text-primary pt-7"><?php echo e($package->weight." ". __('cargo::view.KG')." x ".$package->length." ". __('cargo::view.CM') ." x ".$package->width." ".__('cargo::view.CM')." x ".$package->height." ".__('cargo::view.CM')); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- end: Invoice body-->
            <!-- begin: Invoice footer-->
            <div class="px-8 py-8 mx-0 bg-gray-100 row justify-content-center py-md-10 px-md-0">
                <div class="col-md-10">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th class="font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.PAYMENT_TYPE')); ?></th>
                                    <th class="font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.PAYMENT_STATUS')); ?></th>
                                    <th class="font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.PAYMENT_DATE')); ?></th>
                                    <th class="text-right font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.total_cost')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="font-weight-bolder">
                                    <td><?php echo e($shipment->payment_method_id); ?> (<?php echo e($shipment->getPaymentType()); ?>)</td>
                                    <td><?php if($shipment->paid == 1): ?> <?php echo e(__('cargo::view.paid')); ?><?php else: ?> <?php echo e(__('cargo::view.pending')); ?> <?php endif; ?></td>
                                    <td><?php if($shipment->paid == 1): ?> <?php echo e(\Carbon\Carbon::parse($shipment->payment->payment_date)->format('d-m-Y') ?? ""); ?> <?php else: ?> - <?php endif; ?></td>
                                    <td class="text-right text-primary font-size-h3 font-weight-boldest"><?php echo e(format_price($shipment->tax + $shipment->shipping_cost + $shipment->insurance)); ?><br /><span class="text-muted font-weight-bolder font-size-lg"><?php echo e(__('cargo::view.included_tax_insurance')); ?></span></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- end: Invoice footer-->
            <!-- begin: Invoice action-->
            <div class="px-8 py-8 row justify-content-center py-md-10 px-md-0">
                <div class="col-md-10">
                    <div class="d-flex justify-content-between">
                        <?php
                            $INVOICE_PAYMENT = 'invoice_payment';
                            $cash_payment = 'cash_payment';
                        ?>
                        <?php if($shipment->paid == 0 && $shipment->payment_method_id != $cash_payment && $shipment->payment_method_id != $INVOICE_PAYMENT ): ?>
                            <form action="<?php echo e(route('payment.checkout')); ?>" class="form-default" role="form" method="POST" id="checkout-form">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="shipment_id" value="<?php echo e($shipment->id); ?>">
                                <button type="submit" class="mr-3 btn btn-success btn-md"><?php echo e(__('cargo::view.pay_now')); ?><i class="ml-2 far fa-credit-card"></i></button>
                            </form>
                            <button class="btn btn-success btn-sm " onclick="copyToClipboard('#payment-link')"><?php echo e(__('cargo::view.copy_payment_link')); ?><i class="ml-2 fas fa-copy"></i></button>
                            <div id="payment-link" style="display: none"><?php echo e(route('admin.shipments.pay', $shipment->id)); ?></div>
                        <?php endif; ?>

                        <a href="<?php echo e(route('shipments.print', array($shipment->id, 'label'))); ?>" class="btn btn-light-primary font-weight-bold" target="_blank"><?php echo e(__('cargo::view.print_label')); ?><i class="ml-2 la la-box-open"></i></a>
                        <a href="<?php echo e(route('shipments.print', array($shipment->id, 'invoice'))); ?>" class="btn btn-light-primary font-weight-bold" target="_blank"><?php echo e(__('cargo::view.print_invoice')); ?><i class="ml-2 la la-file-invoice-dollar"></i></a>

                        <?php if($user_role == $admin || auth()->user()->can('edit-shipments')): ?>
                        <a href="<?php echo e(route('shipments.edit', $shipment->id)); ?>" class="px-6 py-3 btn btn-light-info btn-sm font-weight-bolder font-size-sm"><?php echo e(__('cargo::view.edit_shipment')); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <!-- end: Invoice action-->
            <!-- end: Invoice-->
        </div>
    </div>
    <!--end::Card-->

    <?php if(!empty($shipment->shipmentReasons->toArray())): ?>
        <div class="card card-custom card-stretch-half gutter-b">
            <!--begin::List Widget 19-->

            <!--begin::Header-->
            <div class="pt-6 mb-2 border-0 card-header">
                <h3 class="card-title align-items-start flex-column">
                    <span class="mb-3 card-label font-weight-bold font-size-h4 text-dark-75"><?php echo e(__('cargo::view.shipment_return_reasons_log')); ?></span>

                </h3>
                <div class="card-toolbar">

                </div>
            </div>
            <!--end::Header-->
            <!--begin::Body-->
            <div class="pt-2 card-body" style="overflow:hidden">
                <div class="mt-3 timeline timeline-6 scroll scroll-pull" style="overflow:hidden" data-scroll="true" data-wheel-propagation="true">

                <?php $__empty_1 = true; $__currentLoopData = $shipment->shipmentReasons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $shipmentReason): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <!--begin::Item-->
                    <div class="timeline-item align-items-start">
                        <!--begin::Label-->
                        <div class="timeline-label font-weight-bolder text-dark-75 font-size-lg"><?php echo e($shipmentReason->created_at->diffForHumans()); ?></div>
                        <!--end::Label-->

                        <!--begin::Badge-->
                        <div class="timeline-badge">
                            <i class="fa fa-genderless text-warning icon-xl" style="margin-right: 4px;"></i>
                        </div>
                        <!--end::Badge-->

                        <!--begin::Text-->
                        <div class="pl-3 font-weight-mormal font-size-lg timeline-content text-muted">
                            <?php echo e(__('cargo::view.reason').' '.($key+1)); ?>: "<?php echo e($shipmentReason->reason->name); ?>"
                        </div>
                        <!--end::Text-->

                    </div>
                    <!--end::Item-->
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    
                <?php endif; ?>


                </div>
            </div>
        </div>
    <?php endif; ?>

    <!--end::List Widget 19-->
    <?php if(($user_role == $admin || auth()->user()->can('shipments-log')) && !empty($shipment->logs->toArray())): ?>
        <div class="card card-custom card-stretch-half gutter-b">
            <!--begin::List Widget 19-->

            <!--begin::Header-->
            <div class="pt-6 mb-2 border-0 card-header">
                <h3 class="card-title align-items-start flex-column">
                    <span class="mb-3 card-label font-weight-bold font-size-h4 text-dark-75"><?php echo e(__('cargo::view.shipment_status_log')); ?></span>

                </h3>
                <div class="card-toolbar">

                </div>
            </div>
            <!--end::Header-->
            <!--begin::Body-->
            <div class="pt-2 card-body" style="overflow:hidden">
                <div class="mt-3 timeline timeline-6 scroll scroll-pull" style="overflow:hidden" data-scroll="true" data-wheel-propagation="true">

                <?php $__currentLoopData = $shipment->logs()->orderBy('id','desc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <!--begin::Item-->
                    <div class="timeline-item align-items-start">
                        <!--begin::Label-->
                        <div class="timeline-label font-weight-bolder text-dark-75 font-size-lg"><?php echo e($log->created_at->diffForHumans()); ?></div>
                        <!--end::Label-->

                        <!--begin::Badge-->
                        <div class="timeline-badge">
                            <i class="fa fa-genderless text-warning icon-xl" style="margin-right: 4px;"></i>
                        </div>
                        <!--end::Badge-->

                        <!--begin::Text-->
                        <div class="pl-3 font-weight-mormal font-size-lg timeline-content text-muted">
                            <?php echo e(__('cargo::view.changed_from')); ?>: "<?php echo e(Modules\Cargo\Entities\Shipment::getStatusByStatusId($log->from)); ?>" <?php echo e(__('cargo::view.to')); ?>: "<?php echo e(Modules\Cargo\Entities\Shipment::getStatusByStatusId($log->to)); ?>"
                        </div>
                        <!--end::Text-->

                    </div>
                    <!--end::Item-->

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                </div>
            </div>
        </div>
    <?php endif; ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('styles'); ?>
    <style>
        .timeline .timeline-content {
            width: auto;
        }
        .timeline-label{
            margin-right: 6px;
            padding-right: 6px;
            border-right: solid 3px #eff2f5;
        }
        .timeline-label:before{
            width: unset;
        }
    </style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script>
        function copyToClipboard(element) {
            var $temp = $("<input>");
            $("body").append($temp);
            $temp.val($(element).text()).select();
            document.execCommand("copy");
            $temp.remove();
            AIZ.plugins.notify('success', "<?php echo e(__('cargo::view.payment_link_copied')); ?>");
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('cargo::adminLte.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedes/courier.elitedesign.com.bd/Modules/Cargo/Resources/views/adminLte/pages/shipments/show.blade.php ENDPATH**/ ?>