<?php echo csrf_field(); ?>

<?php
$user_role = auth()->user()->role;
$admin = 1;

$is_def_mile_or_fees = Modules\Cargo\Entities\ShipmentSetting::getVal('is_def_mile_or_fees');

$googleSettings = resolve(\app\Models\GoogleSettings::class)->toArray();
$googleMap = json_decode($googleSettings['google_map'], true);
$google_map_key = '';
if ($googleMap) {
    $google_map_key = $googleMap['google_map_key'];
}

$countries = Modules\Cargo\Entities\Country::where('covered', 1)->get();
?>



<div class="form-group" id="kt_repeater_1">
    <div data-repeater-list="address">
        <?php if($typeForm == 'create'): ?>
            <div data-repeater-item class="data-repeater-item-count">

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="col-form-label fw-bold fs-6 required"><?php echo e(__('cargo::view.country')); ?></label>
                            <select name="country_id"class="change-country-client-address form-control select-country <?php $__errorArgs = ['address.*.country_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value=""></option>
                                <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['address.*.country_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="col-form-label fw-bold fs-6 required"><?php echo e(__('cargo::view.region')); ?></label>
                            <select name="state_id"
                                class="change-state-client-address form-control select-state <?php $__errorArgs = ['address.*.state_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value=""></option>

                            </select>
                            <?php $__errorArgs = ['address.*.state_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="col-form-label fw-bold fs-6 required"><?php echo e(__('cargo::view.area')); ?></label>
                            <select name="area_id" style="display: block !important;"
                                class="change-area-client-address form-control select-area <?php $__errorArgs = ['address.*.area_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value=""></option>

                            </select>
                            <?php $__errorArgs = ['address.*.area_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-form-label fw-bold fs-6 required"><?php echo e(__('cargo::view.address')); ?></label>
                    <input type="text" placeholder="<?php echo e(__('cargo::view.address')); ?>" name="address"
                        class="form-control <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" />
                    <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback">
                            <?php echo e($message); ?>

                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <?php if($googleMap): ?>
                    <div class="mt-2 location-client">
                        <label class="col-form-label fw-bold fs-6"><?php echo e(__('cargo::view.location')); ?></label>
                        <input type="text" class="form-control address address-client "
                            placeholder="<?php echo e(__('cargo::view.location')); ?>" name="client_street_address_map"
                            rel="client" value="" />
                        <input type="hidden" class="form-control lat" data-client="lat" name="client_lat" />
                        <input type="hidden" class="form-control lng" data-client="lng" name="client_lng" />
                        <input type="hidden" class="form-control url" data-client="url" name="client_url" />

                        <div class="mt-2 col-sm-12 map_canvas map-client" style="width:100%;height:300px;"></div>
                        <span class="form-text text-muted"><?php echo e('Change the pin to select the right location'); ?></span>
                    </div>
                <?php endif; ?>


            </div>

        <?php elseif($typeForm == 'edit'): ?>
            <?php if($model): ?>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label
                                class="col-form-label fw-bold fs-6 required"><?php echo e(__('cargo::view.country')); ?></label>
                            <select name="country_id"
                                class="change-country-client-address form-control select-country <?php $__errorArgs = ['country_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value=""></option>
                                <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($country->id); ?>"
                                        <?php if($country->id == $model->country_id): ?> selected <?php endif; ?>><?php echo e($country->name); ?>

                                    </option>
                                    <?php
                                        if ($country->id == $model->country_id) {
                                            $states = Modules\Cargo\Entities\State::where('country_id', $model->country_id)->get();
                                        }
                                    ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['country_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <input type="hidden" name="id" value="<?php echo e($model->id); ?>">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label
                                class="col-form-label fw-bold fs-6 required"><?php echo e(__('cargo::view.region')); ?></label>
                            <select name="state_id"
                                class="change-state-client-address form-control select-state <?php $__errorArgs = ['state_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value=""></option>
                                <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($state->id); ?>"
                                        <?php if($state->id == $model->state_id): ?> selected <?php endif; ?>><?php echo e($state->name); ?></option>
                                    <?php
                                        if ($state->id == $model->state_id) {
                                            $areas = Modules\Cargo\Entities\Area::where('state_id', $model->state_id)->get();
                                        }
                                    ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </select>
                            <?php $__errorArgs = ['state_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="col-form-label fw-bold fs-6 required"><?php echo e(__('cargo::view.area')); ?></label>
                            <select name="area_id" style="display: block !important;"
                                class="change-area-client-address form-control select-area <?php $__errorArgs = ['area_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value=""></option>
                                <?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($area->id); ?>"
                                        <?php if($area->id == $model->area_id): ?> selected <?php endif; ?>>
                                        <?php echo e(json_decode($area->name, true)[app()->getLocale()]); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['area_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-form-label fw-bold fs-6 required"><?php echo e(__('cargo::view.address')); ?></label>
                    <input value="<?php echo e($model->address); ?>" type="text" placeholder="<?php echo e(__('cargo::view.address')); ?>"
                        name="address" class="form-control <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" />
                    <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback">
                            <?php echo e($message); ?>

                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <?php if($googleMap): ?>
                    <div class="mt-2 location-client location-client-<?php echo e($model->id); ?>">
                        <label class="col-form-label fw-bold fs-6"><?php echo e(__('cargo::view.location')); ?></label>
                        <input type="text" value="<?php echo e($model->client_street_address_map); ?>"
                            class="form-control address address-client-<?php echo e($model->id); ?> "
                            placeholder="<?php echo e(__('cargo::view.location')); ?>" name="client_street_address_map"
                            rel="client" />
                        <input type="hidden" value="<?php echo e($model->client_lat); ?>" class="form-control lat"
                            data-client="lat" name="client_lat" />
                        <input type="hidden" value="<?php echo e($model->client_lng); ?>" class="form-control lng"
                            data-client="lng" name="client_lng" />
                        <input type="hidden" value="<?php echo e($model->client_url); ?>" class="form-control url"
                            data-client="url" name="client_url" />

                        <div class="mt-2 col-sm-12 map_canvas map_canvas_<?php echo e($model->id); ?> map-client map-client_<?php echo e($model->id); ?>"
                            style="width:100%;height:300px;"></div>
                        <span class="form-text text-muted"><?php echo e('Change the pin to select the right location'); ?></span>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        <?php endif; ?>
    </div>


    <?php if($typeForm == 'create'): ?>
    <div class="form-group row">
        <div class="col-md-12">
            <div>
                <a href="javascript:;" data-repeater-create="" class="btn btn-sm font-weight-bolder btn-light-primary">
                    <i class="la la-plus"></i><?php echo e(__('cargo::view.add_new_address')); ?>

                </a>
            </div>
        </div>
    </div>
    <?php endif; ?>



    <input type="hidden" name="client_id" value="<?php echo e($client->id); ?>">
</div>







<?php $__env->startSection('styles'); ?>
    <style>
        label {
            font-weight: bold !important;
        }

        .card-header {
            display: flex !important;
            align-items: center !important;
        }

    </style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.repeater/1.2.1/jquery.repeater.min.js"
        integrity="sha512-foIijUdV0fR0Zew7vmw98E6mOWd9gkGWQBWaoA1EOFAx+pY+N8FmmtIYAVj64R98KeD2wzZh1aHK0JSpKmRH8w=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.repeater/1.2.1/jquery.repeater.js"
        integrity="sha512-bZAXvpVfp1+9AUHQzekEZaXclsgSlAeEnMJ6LfFAvjqYUVZfcuVXeQoN5LhD7Uw0Jy4NCY9q3kbdEXbwhZUmUQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-touchspin/4.3.0/jquery.bootstrap-touchspin.min.js"
        integrity="sha512-0hFHNPMD0WpvGGNbOaTXP0pTO9NkUeVSqW5uFG2f5F9nKyDuHE3T4xnfKhAhnAZWZIO/gBLacwVvxxq0HuZNqw=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-touchspin/4.3.0/jquery.bootstrap-touchspin.js"
        integrity="sha512-k59zBVzm+v8h8BmbntzgQeJbRVBK6AL1doDblD1pSZ50rwUwQmC/qMLZ92/8PcbHWpWYeFaf9hCICWXaiMYVRg=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.3/umd/popper.min.js"
        integrity="sha384-vFJXuSJphROIrBnz7yo7oB41mKfc8JzQZiCq4NCceLEaO4IHwicKwpJf9c9IpFgh" crossorigin="anonymous">
    </script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta.2/js/bootstrap.min.js"
        integrity="sha384-alpBpkh1PFOepccYVYDB4do5UnbKysX5WZXm3XxPqe5iKTfUKjNkCk9SaVuEZflJ" crossorigin="anonymous">
    </script>
    <script src="<?php echo e(asset('assets/global/js/jquery.geocomplete.js')); ?>"></script>
    <script src="//maps.googleapis.com/maps/api/js?libraries=places&key=<?php echo e($google_map_key); ?>"></script>
    <script>
        var typeForm = '<?php echo e($typeForm); ?>';
        if (typeForm == 'edit') {
            <?php if(isset($model)): ?>
                $('.address-client-<?php echo e($model->id); ?>').each(function(){
                var address = $(this);
                var lat = '<?php echo e($model->client_lat); ?>';
                lat = parseFloat(lat);
                var lng = '<?php echo e($model->client_lng); ?>';
                lng = parseFloat(lng);

                address.geocomplete({
                map: ".map_canvas_<?php echo e($model->id); ?>.map-client_<?php echo e($model->id); ?>",
                mapOptions: {
                zoom: 8,
                center: { lat: lat, lng: lng },

                },
                markerOptions: {
                draggable: true
                },
                details: ".location-client-<?php echo e($model->id); ?>",
                detailsAttribute: 'data-client',
                autoselect: true,
                restoreValueAfterBlur: true,
                });
                address.bind("geocode:dragged", function(event, latLng){
                $("input[data-client=lat]").val(latLng.lat());
                $("input[data-client=lng]").val(latLng.lng());
                });
                });
            <?php endif; ?>
        } else {
            $('.address-client').each(function() {
                var address = $(this);
                address.geocomplete({
                    map: ".map_canvas.map-client",
                    mapOptions: {
                        zoom: 8,
                        center: {
                            lat: -34.397,
                            lng: 150.644
                        },
                    },
                    markerOptions: {
                        draggable: true
                    },
                    details: ".location-client",
                    detailsAttribute: 'data-client',
                    autoselect: true,
                    restoreValueAfterBlur: true,
                });
                address.bind("geocode:dragged", function(event, latLng) {
                    $("input[data-client=lat]").val(latLng.lat());
                    $("input[data-client=lng]").val(latLng.lng());
                });
            });
        }
        //Address Types Repeater
        $('#kt_repeater_1').repeater({
            initEmpty: false,

            show: function() {
                var repeater_item = $(this);
                <?php if($googleMap): ?>
                    var map_canvas = repeater_item.find(".map_canvas.map-client");
                    var map_data = repeater_item.find(".location-client");
                    repeater_item.find(".address").geocomplete({
                    map: map_canvas,
                    mapOptions: {
                    zoom: 18,
                    center: { lat: -34.397, lng: 150.644 },
                    },
                    markerOptions: {
                    draggable: true
                    },
                    details: map_data,
                    detailsAttribute: "data-client",
                    autoselect: true,
                    restoreValueAfterBlur: true,
                    });
                    repeater_item.find(".address").bind("geocode:dragged", function(event, latLng){
                    repeater_item.find("input[data-client=lat]").val(latLng.lat());
                    repeater_item.find("input[data-client=lng]").val(latLng.lng());
                    });
                <?php endif; ?>


                $(this).slideDown();

                changeCountry();
                changeState();
                selectPlaceholder();
            },

            hide: function(deleteElement) {
                $(this).slideUp(deleteElement);
            },

            isFirstItemUndeletable: true
        });

        function changeCountry() {
            $('.change-country-client-address').change(function() {
                var id = $(this).parent().find(".change-country-client-address").val();
                var row = $(this).closest(".row");
                var state_input = row.find(".change-state-client-address");
                var state_name = state_input.attr("name");

                $.get("<?php echo e(route('ajax.getStates')); ?>?country_id=" + id, function(data) {
                    $('select[name ="' + state_name + '"]').empty();
                    $('select[name ="' + state_name + '"]').append('<option value=""></option>');
                    for (let index = 0; index < data.length; index++) {
                        const element = data[index];
                        $('select[name ="' + state_name + '"]').append('<option value="' + element['id'] +
                            '">' + element['name'] + '</option>');
                    }
                });
            });
        }
        changeCountry();

        function changeState() {
            $('.change-state-client-address').change(function() {

                var id = $(this).parent().find(".change-state-client-address").val();
                var row = $(this).closest(".row");
                var area_input = row.find(".change-area-client-address");
                var area_name = area_input.attr("name");
                console.log(area_name);
                $.get("<?php echo e(route('ajax.getAreas')); ?>?state_id=" + id, function(data) {
                    $('select[name ="' + area_name + '"]').empty();
                    $('select[name ="' + area_name + '"]').append('<option value=""></option>');
                    for (let index = 0; index < data.length; index++) {
                        const element = data[index];
                        $('select[name ="' + area_name + '"]').append('<option value="' + element['id'] +
                            '">' + JSON.parse(element['name'], true)[`<?php echo e(app()->getLocale()); ?>`] +
                            '</option>');
                    }
                });
            });
        }
        changeState();

        function selectPlaceholder() {
            $('.select-country').select2({
                placeholder: "<?php echo e(__('cargo::view.choose_country')); ?>",
                width: '100%'
            })
            <?php if(auth()->user()->can('add-covered-countries') || $user_role == $admin): ?>
                .on('select2:open', () => {
                $(".select2-results:not(:has(a))").append(`<li style='list-style: none; padding: 10px;'><a style="width: 100%"
                        href="<?php echo e(route('countries.index')); ?>?redirect=shipments.create"
                        class="btn btn-primary"><?php echo e(__('cargo::view.manage')); ?> <?php echo e(__('cargo::view.covered_countries')); ?></a>
                </li>`);
                });
            <?php endif; ?>

            $('.select-state').select2({
                placeholder: "<?php echo e(__('cargo::view.choose_region')); ?>",
                width: '100%'
            })
            <?php if(auth()->user()->can('add-covered-regions') || $user_role == $admin): ?>
                .on('select2:open', () => {
                $(".select2-results:not(:has(a))").append(`<li style='list-style: none; padding: 10px;'><a style="width: 100%"
                        href="<?php echo e(route('countries.index')); ?>?redirect=shipments.create"
                        class="btn btn-primary"><?php echo e(__('cargo::view.manage')); ?> <?php echo e(__('cargo::view.covered_regions')); ?></a>
                </li>`);
                });
            <?php endif; ?>

            $('.select-area').select2({
                placeholder: "<?php echo e(__('cargo::view.choose_area')); ?>",
                width: '100%'
            })
            <?php if(auth()->user()->can('manage-areas') || $user_role == $admin): ?>
                .on('select2:open', () => {
                $(".select2-results:not(:has(a))").append(`<li style='list-style: none; padding: 10px;'><a style="width: 100%"
                        href="<?php echo e(route('areas.index')); ?>?redirect=shipments.create"
                        class="btn btn-primary"><?php echo e(__('cargo::view.manage')); ?> <?php echo e(__('cargo::view.areas')); ?></a>
                </li>`);
                });
            <?php endif; ?>
        }
        selectPlaceholder();

        $('#check').click(function() {
            const type = $('#password').attr('type') === 'password' ? 'text' : 'password';
            $('#password').prop('type', type);
        });
    </script>
<?php $__env->stopSection(); ?>
<?php /**PATH C:\xampp\htdocs\Modules/Cargo\Resources/views/adminLte/pages/clients/form_address.blade.php ENDPATH**/ ?>