<?php
    use \Milon\Barcode\DNS1D;
    $d = new DNS1D();
    $user_role = auth()->user()->role;
    $admin  = 1;
    $driver = 5;
    $code = filter_var($mission->code, FILTER_SANITIZE_NUMBER_INT);

    $mission_shipments = Modules\Cargo\Entities\ShipmentMission::where('mission_id',$mission->id)->get();
?>



<?php $__env->startSection('pageTitle'); ?>
    <?php echo e(__('cargo::view.mission').'-'. $mission->code); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!--begin::Entry-->
<div class="d-flex flex-column-fluid">
    <!--begin::Container-->
    <div class="container">
        <!-- begin::Card-->
        <div class="overflow-hidden card card-custom">
            <div class="p-0 card-body">
                <!-- begin: Invoice-->
                <!-- begin: Invoice header-->
                <div class="px-8 py-8 row justify-content-center py-md-27 px-md-0">
                    <div class="col-md-9">
                        <div class="pb-10 d-flex justify-content-between pb-md-20 flex-column flex-md-row">
                            <h1 class="mb-10 display-4 font-weight-boldest">
                                <?php 
                                    $system_logo = App\Models\Settings::where('group', 'general')->where('name','system_logo')->first();
                                ?>
                                <img alt="Logo" src="<?php echo e($system_logo->getFirstMediaUrl('system_logo') ? $system_logo->getFirstMediaUrl('system_logo') : asset('assets/lte/cargo-logo.svg')); ?>" class="logo" style="max-height: 90px;" />
                                <?php echo e(__('cargo::view.MISSION_DETAILS')); ?>

                            </h1>
                            <div class="px-0 d-flex flex-column align-items-md-end">
                                <!--begin::Logo-->
                                <a href="#">
                                    <?php if($code != null): ?>
                                        <?php
                                            echo '<img src="data:image/png;base64,' . $d->getBarcodePNG($code, "C128") . '" alt="barcode"   />';
                                        ?>
                                    <?php endif; ?>
                                </a>
                                <!--end::Logo-->
                                <span class="d-flex flex-column align-items-md-end opacity-70">
                                    <br />
                                    <span><span class="font-weight-bolder"><?php echo e(__('cargo::view.CREATED_DATE')); ?>:</span> <?php echo e($mission->created_at->format('Y-m-d')); ?></span>
                                    <span><span class="font-weight-bolder"><?php echo e(__('cargo::view.CODE')); ?>:</span> <?php echo e($mission->code); ?></span>
                                </span>
                            </div>
                        </div>
                        <div class="border-bottom w-100"></div>
                        <div class="pt-6 d-flex justify-content-between">
                            <div class="d-flex flex-column flex-root">
                                <span class="mb-2 font-weight-bolder d-block"><?php echo e(__('cargo::view.MISSION_TYPE')); ?><span>
                                <span class="opacity-70 d-block"><?php echo e($mission->type); ?></span>
                            </div>
                            <?php if($mission->type == Modules\Cargo\Entities\Mission::getType(Modules\Cargo\Entities\Mission::TRANSFER_TYPE) ): ?>
                                <div class="d-flex flex-column flex-root">
                                    <span class="mb-2 font-weight-bolder d-block"><?php echo e(__('cargo::view.TRANSFER_TO_BRANCH')); ?><span>
                                    <span class="opacity-70 d-block"><?php echo e($mission->to_branch->name); ?></span>
                                </div>
                            <?php else: ?>
                                <div class="d-flex flex-column flex-root">
                                    <span class="mb-2 font-weight-bolder d-block"><?php echo e(__('cargo::view.MISSION_ADDRESS')); ?><span>
                                    <span class="opacity-70 d-block"><?php echo e($mission->address); ?></span>
                                </div>
                            <?php endif; ?>
                            <div class="d-flex flex-column flex-root">
                                <span class="mb-2 font-weight-bolder d-block"><?php echo e(__('cargo::view.MISSION_STATUS')); ?><span>
                                <span class="opacity-70 d-block text-<?php echo e(Modules\Cargo\Entities\Mission::getStatusColor($mission->status_id)); ?>"><?php echo e($mission->getStatus()); ?></span>
                            </div>
                            <?php if($mission->captain_id): ?>
                                <div class="d-flex flex-column flex-root">
                                    <span class="mb-2 font-weight-bolder d-block"><?php echo e(__('cargo::view.MISSION_Driver')); ?><span>
                                    <span class="opacity-70 d-block"><?php echo e($mission->captain->name); ?></span>
                                </div>
                            <?php endif; ?>
                            <?php if($due_date): ?>
                                <div class="d-flex flex-column flex-root">
                                    <span class="mb-2 font-weight-bolder d-block"><?php echo e(__('cargo::view.DUE_DATE')); ?><span>
                                    <span class="opacity-70 d-block"><?php echo e($due_date ?? ""); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <!-- end: Invoice header-->
                <!-- begin: Invoice body-->
                
                <div class="row justify-content-center py-md-10 px-md-0" style="padding: 4.25rem!important;">
                    <div class="col-12 row">
                        <div class="col-12">
                            <h1 class="mb-10 display-4 font-weight-boldest"><?php echo e(__('cargo::view.mission_shipments').' '); ?>(<?php echo e(count($mission_shipments)); ?>)</h1>
                        </div>
                        <?php if(isset($reschedule)): ?>
                            <div class="text-right col-6">
                                <!-- Button trigger modal -->
                                <button type="button" class="mb-5 btn btn-sm btn-primary" data-toggle="modal" data-target="#exampleModalCenter" id="modal_open">
                                    <?php echo e(__('cargo::view.reschedule')); ?>

                                </button>
                            
                                <!-- Modal -->
                                <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLongTitle"><?php echo e(__('cargo::view.reschedule')); ?></h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close" id="modal_close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <form action="<?php echo e(route('missions.reschedule')); ?>" method="POST" enctype="multipart/form-data">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="id" value="<?php echo e($mission->id); ?>">
                                                <div class="text-left modal-body">
                                                    <div class="row">
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label><?php echo e(__('cargo::view.reason')); ?>:</label>
                                                                
                                                                <select name="reason" class="form-control mb-4 captain_id kt-select2">
                                                                    <?php $__currentLoopData = $reasons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reason): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($reason->id); ?>"><?php echo e($reason->name); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label><?php echo e(__('cargo::view.due_date')); ?>:</label>
                                                                <input type="text" id="kt_datepicker_3" autocomplete="off" class="form-control"  name="due_date"/>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('cargo::view.close')); ?></button>
                                                    <button type="submit" class="btn btn-primary"><?php echo e(__('cargo::view.save')); ?></button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th width="3%">#</th>
                                        <th class="pl-0 font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.table.code')); ?></th>
                                        <th class=" font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.status')); ?></th>
                                        <th class="text-right font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.type')); ?></th>
                                        <th class="text-right font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.table.branch')); ?></th>
                                        <th class="text-right font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.client')); ?></th>
                                        <th class="text-right font-weight-bold text-muted text-uppercase"><?php echo e(__('cargo::view.payment_type')); ?></th>
                                        <th class="text-right font-weight-bold text-muted text-uppercase">
                                            <?php if($mission->getRawOriginal('type') == Modules\Cargo\Entities\Mission::DELIVERY_TYPE): ?>
                                                <?php echo e(__('cargo::view.COD_AMOUNT')); ?>

                                            <?php else: ?>
                                                <?php echo e(__('cargo::view.TOTAL_COST')); ?>

                                            <?php endif; ?>
                                        </th>
                                        <th class="text-center font-weight-bold text-muted text-uppercase no-print"><?php echo e(__('cargo::view.actions')); ?></th>
                                        <th class="text-center font-weight-bold text-muted text-uppercase print-only"><?php echo e(__('cargo::view.check')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                
                                <?php $__currentLoopData = $mission_shipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $shipment_mission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="font-weight-boldest <?php if(in_array($shipment_mission->shipment->status_id ,[Modules\Cargo\Entities\Shipment::RETURNED_STATUS,Modules\Cargo\Entities\Shipment::RETURNED_STOCK,Modules\Cargo\Entities\Shipment::RETURNED_CLIENT_GIVEN])): ?> table-danger <?php endif; ?>">
                                        <td class="text-right pt-7" width="3%"><?php echo e(($key+1)); ?></td>
                                        <?php if(in_array($user_role ,[$admin,$driver]) || auth()->user()->can('view-shipments') ): ?>
                                            <td class="text-right pt-7"><a href="<?php echo e(route('shipments.show', ['shipment'=>$shipment_mission->shipment->id])); ?>"><?php echo e($shipment_mission->shipment->code); ?></a></td>
                                        <?php else: ?>
                                            <td class="text-right pt-7"><?php echo e($shipment_mission->shipment->code); ?></td>
                                        <?php endif; ?>
                                        <td class="text-right pt-7"><?php echo e($shipment_mission->shipment->getStatus()); ?></td>
                                        <td class="text-right pt-7"><?php echo e($shipment_mission->shipment->type); ?></td>
                                        <td class="text-right pt-7"><?php echo e($shipment_mission->shipment->branch->name); ?></td>
                                        <td class="text-right pt-7"><?php echo e($shipment_mission->shipment->client->name); ?></td>
                                        <td class="text-right pt-7"><?php echo e($shipment_mission->shipment->payment_method_id); ?> (<?php echo e($shipment_mission->shipment->getPaymentType()); ?>)</td>

                                        <?php if($shipment_mission->shipment->payment_type == Modules\Cargo\Entities\Shipment::POSTPAID): ?>
                                            <td class="text-right pt-7"><?php echo e(format_price($shipment_mission->shipment->amount_to_be_collected + $shipment_mission->shipment->tax + $shipment_mission->shipment->shipping_cost + $shipment_mission->shipment->insurance)); ?></td>
                                        <?php elseif($shipment_mission->shipment->payment_type == Modules\Cargo\Entities\Shipment::PREPAID): ?>

                                            <?php if($mission->getRawOriginal('type') == Modules\Cargo\Entities\Mission::DELIVERY_TYPE): ?>
                                                <td class="text-right pt-7"><?php echo e(format_price($shipment_mission->shipment->amount_to_be_collected)); ?></td>
                                            <?php else: ?>
                                                <td class="text-right pt-7"><?php echo e(format_price($shipment_mission->shipment->tax + $shipment_mission->shipment->shipping_cost + $shipment_mission->shipment->insurance)); ?></td>
                                            <?php endif; ?>

                                        <?php endif; ?>
                                        
                                        <td class="pr-5 text-right text-danger pt-7 no-print">
                                            <?php if(in_array($shipment_mission->mission->status_id , [Modules\Cargo\Entities\Mission::APPROVED_STATUS,Modules\Cargo\Entities\Mission::REQUESTED_STATUS,Modules\Cargo\Entities\Mission::RECIVED_STATUS]) && $shipment_mission->shipment->mission_id != null): ?>
                                                <!-- Button trigger modal -->
                                                <?php if($mission->status_id == Modules\Cargo\Entities\Mission::RECIVED_STATUS): ?>
                                                    <?php if($shipment_mission->mission->getRawOriginal('type') == Modules\Cargo\Entities\Mission::DELIVERY_TYPE): ?>
                                                    <a class="btn btn-success btn-sm mb-1" data-url="<?php echo e(route('admin.missions.action.confirm_amount', ['mission_id' => $mission->id , 'shipment_id' => $shipment_mission->shipment->id ])); ?>" data-action="POST" onclick="openAjexedModel(this,event)" href="<?php echo e(route('missions.show', $mission->id)); ?>" title="<?php echo e(__('cargo::view.show')); ?>">
                                                        <i class="fa fa-check"></i> <?php echo e(__('cargo::view.confirm_done')); ?>

                                                    </a>
                                                    <?php endif; ?>
                                                <?php endif; ?>

                                                <button type="button" class="px-3 mb-1 btn btn-sm btn-primary" data-toggle="modal" data-target="#exampleModalCenter2" id="modal_open_delete_shipment" onclick="set_shipment_id(<?php echo e($shipment_mission->shipment->id); ?>)">
                                                    <?php if($shipment_mission->mission->getRawOriginal('type') == Modules\Cargo\Entities\Mission::DELIVERY_TYPE): ?>
                                                        <?php echo e(__('cargo::view.return')); ?>

                                                    <?php else: ?>
                                                        <?php echo e(__('cargo::view.remove_from')); ?> <?php echo e($mission->code); ?>

                                                    <?php endif; ?>
                                                </button>
                                                
                                            <?php else: ?>
                                                <?php echo e(__('cargo::view.no_actions')); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td class="text-center print-only"><input type="checkbox" class="form-control" /></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div id="ajaxed-model" class="modal fade">
                    <div class="modal-dialog">
                        <div class="modal-content">



                        </div>
                    </div>
                </div>

                <!-- Modal -->
                <div class="modal fade" id="exampleModalCenter2" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter2Title" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLongTitle">
                                    <?php if($mission->getRawOriginal('type') == Modules\Cargo\Entities\Mission::DELIVERY_TYPE): ?>
                                        <?php echo e(__('cargo::view.return_shipment')); ?>

                                    <?php else: ?>
                                        <?php echo e(__('cargo::view.remove_from')); ?> <?php echo e($mission->code); ?>

                                    <?php endif; ?>
                                </h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close" id="modal_close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <form action="<?php echo e(route('shipments.delete-shipment-from-mission')); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="mission_id" value="<?php echo e($mission->id); ?>">
                                <input type="hidden" name="shipment_id" id="delete_shipment_id" value="">
                                <div class="text-left modal-body">
                                    <?php if(isset($reasons)): ?>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label><?php echo e(__('cargo::view.reason')); ?>:</label>
                                                
                                                <select name="reason" class="form-control captain_id kt-select2" required>
                                                    <?php $__currentLoopData = $reasons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reason): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($reason->id); ?>"><?php echo e($reason->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('cargo::view.close')); ?></button>
                                    <button type="submit" class="btn btn-danger">
                                    <?php if($mission->getRawOriginal('type') == Modules\Cargo\Entities\Mission::DELIVERY_TYPE): ?>
                                        <?php echo e(__('cargo::view.return')); ?>

                                    <?php else: ?>
                                        <?php echo e(__('cargo::view.remove')); ?>

                                    <?php endif; ?>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- end: Invoice body-->
                <?php if($mission->type != Modules\Cargo\Entities\Mission::getType(Modules\Cargo\Entities\Mission::TRANSFER_TYPE)  ): ?>
                    <!-- begin: Invoice footer-->
                    <div class="px-8 py-8 bg-gray-100 row justify-content-center py-md-10 px-md-0">
                        <div class="col-md-9">
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <?php if($mission->status_id == Modules\Cargo\Entities\Mission::REQUESTED_STATUS || $mission->status_id == Modules\Cargo\Entities\Mission::APPROVED_STATUS || $mission->status_id == Modules\Cargo\Entities\Mission::RECIVED_STATUS): ?>
                                                <?php if($mission->type == Modules\Cargo\Entities\Mission::getType(Modules\Cargo\Entities\Mission::SUPPLY_TYPE)): ?>
                                                    <th class="text-right font-weight-bold text-muted text-uppercase "><?php echo e(__('cargo::view.RETURN_AMOUNT')); ?></th>
                                                <?php endif; ?>
                                            <?php endif; ?>

                                            <?php if($mission->type == Modules\Cargo\Entities\Mission::getType(Modules\Cargo\Entities\Mission::DELIVERY_TYPE)): ?>
                                                <th class="text-right font-weight-bold text-muted text-uppercase "><?php echo e(__('cargo::view.TOTAL_COD_AMOUNT')); ?></th>
                                            <?php else: ?>
                                                <th class="text-right font-weight-bold text-muted text-uppercase "><?php echo e(__('cargo::view.TOTAL_COST')); ?></th>
                                            <?php endif; ?>

                                        </tr>
                                    </thead>

                                    <tbody>
                                        <tr class="font-weight-bolder">
                                            <?php if($mission->status_id == Modules\Cargo\Entities\Mission::REQUESTED_STATUS || $mission->status_id == Modules\Cargo\Entities\Mission::APPROVED_STATUS || $mission->status_id == Modules\Cargo\Entities\Mission::RECIVED_STATUS): ?>
                                                <?php if($mission->type == Modules\Cargo\Entities\Mission::getType(Modules\Cargo\Entities\Mission::SUPPLY_TYPE)): ?>
                                                    <td class="text-right text-primary font-size-h3 font-weight-boldest"><?php echo e(format_price($cod)); ?></td>
                                                <?php endif; ?>
                                            <?php endif; ?>

                                            <?php if($mission->status_id == Modules\Cargo\Entities\Mission::DONE_STATUS && ( $mission->getRawOriginal('type') == Modules\Cargo\Entities\Mission::SUPPLY_TYPE || $mission->getRawOriginal('type') == Modules\Cargo\Entities\Mission::DELIVERY_TYPE )): ?>
                                                <td class="text-right text-primary font-size-h3 font-weight-boldest"><?php echo e(format_price($mission->amount)); ?></td>
                                            <?php else: ?>
                                                <td class="text-right text-primary font-size-h3 font-weight-boldest"><?php echo e(format_price($shipment_cost)); ?></td>
                                            <?php endif; ?>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- end: Invoice footer-->
                <?php endif; ?>
                <!-- begin: Invoice action-->
                <div class="px-8 py-8 row justify-content-center py-md-10 px-md-0 no-print">
                    <div class="col-md-9">
                        <div class="d-flex justify-content-between">
                            <button type="button" class="btn btn-primary font-weight-bold" onclick="window.print();"><?php echo e(__('cargo::view.Print_Mission')); ?></button>
                        </div>
                    </div>
                </div>
                <!-- end: Invoice action-->
                <!-- end: Invoice-->
            </div>
        </div>
        <!-- end::Card-->
    </div>
    <!--end::Container-->
</div>
<!--end::Entry-->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('styles'); ?>
    <style media="print">
        .print-only{
            display: block;
        }
        .no-print, div#kt_header_mobile, div#kt_header, div#kt_footer{
            display: none;
        }
    </style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.3/umd/popper.min.js" integrity="sha384-vFJXuSJphROIrBnz7yo7oB41mKfc8JzQZiCq4NCceLEaO4IHwicKwpJf9c9IpFgh" crossorigin="anonymous"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta.2/js/bootstrap.min.js" integrity="sha384-alpBpkh1PFOepccYVYDB4do5UnbKysX5WZXm3XxPqe5iKTfUKjNkCk9SaVuEZflJ" crossorigin="anonymous"></script>
    <script>
        var inputDate = $(`#kt_datepicker_3`);

        // Trigger date picker for Shipping Date
        inputDate.daterangepicker({
            showDropdowns: true,
            singleDatePicker: true,
            autoUpdateInput: false,
            autoclose: true,
            minYear: parseInt(moment().format('YYYY')) - 10,
            maxYear: parseInt(moment().format('YYYY')) + 10,
            todayHighlight: true,
            startDate: new Date(),
            todayBtn: true,
            locale: {
                format: "DD/MM/YYYY",
                cancelLabel: "<?php echo e(__('view.cancel')); ?>",
                applyLabel: "<?php echo e(__('view.apply')); ?>",
                "fromLabel": "<?php echo e(__('view.from')); ?>",
                "toLabel": "<?php echo e(__('view.to')); ?>",
                "customRangeLabel": "<?php echo e(__('datepicker.custom_range')); ?>",
                "weekLabel": "<?php echo e(__('datepicker.week_label')); ?>",
                "daysOfWeek": [
                    "<?php echo e(__('datepicker.days_of_week.sunday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.monday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.tuesday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.wednesday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.thursday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.friday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.saturday')); ?>",
                ],
                "monthNames": [
                    "<?php echo e(__('datepicker.month_names.january')); ?>",
                    "<?php echo e(__('datepicker.month_names.february')); ?>",
                    "<?php echo e(__('datepicker.month_names.march')); ?>",
                    "<?php echo e(__('datepicker.month_names.april')); ?>",
                    "<?php echo e(__('datepicker.month_names.may')); ?>",
                    "<?php echo e(__('datepicker.month_names.june')); ?>",
                    "<?php echo e(__('datepicker.month_names.july')); ?>",
                    "<?php echo e(__('datepicker.month_names.august')); ?>",
                    "<?php echo e(__('datepicker.month_names.september')); ?>",
                    "<?php echo e(__('datepicker.month_names.october')); ?>",
                    "<?php echo e(__('datepicker.month_names.november')); ?>",
                    "<?php echo e(__('datepicker.month_names.december')); ?>",
                ],
            }
        }, cb);

        // call back after choose date
        function cb(start) {
            var apiDate = start ? start.format("YYYY-MM-DD H:m") : '';
            var inputShowDate = start ? (start.format("YYYY-MM-DD")) : '';
            if (start) {
                inputDate.val(inputShowDate);
            }
        }

        function set_shipment_id(shipment_id){
            document.getElementById('delete_shipment_id').value = shipment_id;
        }
        function openAjexedModel(element,event)
        {
            event.preventDefault();

            show_ajax_loder_in_button(element);
            $.ajax({
                url: $(element).data('url'),
                type: 'get',
                success: function(response){
                // Add response in Modal body
                $('#ajaxed-model .modal-content').html(response);
                // Display Modal
                $('#ajaxed-model').modal('toggle');
                }
            });
        }
        function show_ajax_loder_in_button(element){
            $(element).bind('ajaxStart', function(){
                $(this).addClass('spinner spinner-darker-success spinner-left mr-3');
                $(this).attr('disabled','disabled');
            }).bind('ajaxStop', function(){
                $(this).removeClass('spinner spinner-darker-success spinner-left mr-3');
                $(this).removeAttr('disabled');
            });
        }
        $('#ajaxed-model').on('hidden.bs.modal', function () {
            $('#ajaxed-model .modal-content').empty();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('cargo::adminLte.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedesignbd/courier.elitedesign.com.bd/Modules/Cargo/Resources/views/adminLte/pages/missions/show.blade.php ENDPATH**/ ?>