<div class="mb-10">
    <!--begin::Label-->
    <label class="form-label fs-5 fw-bold mb-3"><?php echo e(__('view.created_at')); ?>:</label>
    <!--end::Label-->
    <!--begin::Options-->
    <input class="form-control form-control-solid" placeholder="<?php echo e(__('view.pick_date_range')); ?>" id="<?php echo e($table_id); ?>_created_at_filter"/>
    <!--end::Options-->
</div>




<?php $__env->startPush('js-component'); ?>
    <script>
        setTimeout(() => {
            var table_id = '<?php echo e($table_id); ?>';
            var inputDate = $(`#${table_id}_created_at_filter`);
            var formOptions = $(`#${table_id}_filter_options_form`);
            var dataTableInstance = $(`#${table_id}`).DataTable();
            var start, end;

            // Trigger date picker for created at
            inputDate.daterangepicker({
                showDropdowns: true,
                autoUpdateInput: false,
                ranges: {
                    "<?php echo e(__('datepicker.custom_range_titles.yesterday')); ?>": [moment().subtract(1, "days"), moment().subtract(1, "days")],
                    "<?php echo e(__('datepicker.custom_range_titles.last_7_days')); ?>": [moment().subtract(6, "days"), moment()],
                    "<?php echo e(__('datepicker.custom_range_titles.last_30_days')); ?>": [moment().subtract(29, "days"), moment()],
                    "<?php echo e(__('datepicker.custom_range_titles.this_month')); ?>": [moment().startOf("month"), moment().endOf("month")],
                    "<?php echo e(__('datepicker.custom_range_titles.last_month')); ?>": [moment().subtract(1, "month").startOf("month"), moment().subtract(1, "month").endOf("month")],
                    "<?php echo e(__('datepicker.custom_range_titles.this_year')); ?>": [moment().startOf("year"), moment().endOf("year")],
                    "<?php echo e(__('datepicker.custom_range_titles.last_year')); ?>": [moment().subtract(1, "year").startOf("year"), moment().subtract(1, "year").endOf("year")],
                },
                
                locale: {
                    format: "DD/MM/YYYY",
                    cancelLabel: "<?php echo e(__('view.cancel')); ?>",
                    applyLabel: "<?php echo e(__('view.apply')); ?>",
                    "fromLabel": "<?php echo e(__('view.from')); ?>",
                    "toLabel": "<?php echo e(__('view.to')); ?>",
                    "customRangeLabel": "<?php echo e(__('datepicker.custom_range')); ?>",
                    "weekLabel": "<?php echo e(__('datepicker.week_label')); ?>",
                    "daysOfWeek": [
                        "<?php echo e(__('datepicker.days_of_week.sunday')); ?>",
                        "<?php echo e(__('datepicker.days_of_week.monday')); ?>",
                        "<?php echo e(__('datepicker.days_of_week.tuesday')); ?>",
                        "<?php echo e(__('datepicker.days_of_week.wednesday')); ?>",
                        "<?php echo e(__('datepicker.days_of_week.thursday')); ?>",
                        "<?php echo e(__('datepicker.days_of_week.friday')); ?>",
                        "<?php echo e(__('datepicker.days_of_week.saturday')); ?>",
                    ],
                    "monthNames": [
                        "<?php echo e(__('datepicker.month_names.january')); ?>",
                        "<?php echo e(__('datepicker.month_names.february')); ?>",
                        "<?php echo e(__('datepicker.month_names.march')); ?>",
                        "<?php echo e(__('datepicker.month_names.april')); ?>",
                        "<?php echo e(__('datepicker.month_names.may')); ?>",
                        "<?php echo e(__('datepicker.month_names.june')); ?>",
                        "<?php echo e(__('datepicker.month_names.july')); ?>",
                        "<?php echo e(__('datepicker.month_names.august')); ?>",
                        "<?php echo e(__('datepicker.month_names.september')); ?>",
                        "<?php echo e(__('datepicker.month_names.october')); ?>",
                        "<?php echo e(__('datepicker.month_names.november')); ?>",
                        "<?php echo e(__('datepicker.month_names.december')); ?>",
                    ],
                }
            }, cb);

            // call back after choose date
            function cb(start, end) {
                var startDate = start ? start.format("YYYY-MM-DD") : ''
                var endDate = end ? end.format("YYYY-MM-DD") : ''
                if (startDate) {
                    inputDate.val(startDate + ' / ' + endDate);
                    var menuElement = document.querySelector(`#${table_id}_filter_options`)
                    var menu = KTMenu.getInstance(menuElement);
                    setTimeout(() => {
                        menu.show()
                    })
                }
                // get data by selected date
                dataTableInstance.on('preXhr.dt', function (e, settings, data) {
                    if (!data.filter) {
                        data.filter = {}
                    }
                    data.filter.created_at_start = startDate
                    data.filter.created_at_end = endDate
                })
                // dataTableInstance.ajax.reload()                
            }
            cb(start, end);

            formOptions.on('reset', function(e) {
                dataTableInstance.on('preXhr.dt', function (e, settings, data) {
                    if (data.filter) {
                        data.filter.created_at_start = ''
                        data.filter.created_at_end = ''
                    }
                })
            })
        }, 1000);
    </script>
<?php $__env->stopPush(); ?><?php /**PATH /home/elitedes/courier.elitedesign.com.bd/resources/views/adminLte/components/modules/datatable/filters/created_at.blade.php ENDPATH**/ ?>